function [ Ext_Delta,n ] = extpar( Delta, r, d )
%Build Extended Knot Partition for S^r_d(\Delta)
%   Delta is a row vector listing the knots including endpoints.  d is the
%   polynomial degree and r is the connecting degree of smoothness.

Ext_Delta = zeros(1,d+1) + Delta(1,1); %First end with d+1 copies
for j=2:size(Delta,2)
    if j == size(Delta,2)
        Ext_Delta = [Ext_Delta zeros(1,d+1)+Delta(1,j)]; %At end d+1 copies
    else
        Ext_Delta = [Ext_Delta zeros(1,d-r)+Delta(1,j)]; %In int d-r copies
    end
end

k = size(Delta,2)-2; %Number of interior knots
n = (k+1)*(d+1)-k*(r+1); %Dimension of S^r_d(Delta)
end

